# Vision — Steadiness Predicate (Pinned)

**Goal.** Find the critical flicker frequency \( f_c(\Theta) \) where a flicker becomes **steady** under a window of length Θ, and check the scaling law \( f_c \propto 1/\Theta \).

We pin a **DC‑fraction** predicate and a **single lens constant** \( k \) (cycles per series). Prediction:  
\[
f_{\text{pred}}(\Theta) = \frac{k}{\Theta}.
\]

## Predicate (d_out)

- On each Θ‑long window, compute the **DC energy fraction**
  \[
  \rho_\Theta = \frac{E_{\text{DC}}}{E_{\text{total}}}
  \]
  where DC is the window mean and total is sum of squares.
- **Steady** iff \( \rho_\Theta \ge 1 - \varepsilon_\rho \).

## Calibration (once)

- Use **sinusoidal flicker** (amplitude A, constant across Θ).  
- At \( \Theta=16 \), bracket‑and‑bisect around the nominal \(N_t/(2\Theta)\) to find \( f_{c,\text{emp}} \).  
- Set the **lens constant** \( k = \Theta \cdot f_{c,\text{emp}} \). Freeze \( k \) and \( \varepsilon_\rho \) for this instrument.

## Evaluation

- For each \( \Theta \in \{8,16,32\} \): bracket \([0.9\,k/\Theta,\,1.1\,k/\Theta]\); bisect to ≤ 5% width. Record the smallest passing frequency as \( f_{c,\text{emp}} \).

## Acceptance

- Relative error: \( \big| f_{c,\text{emp}} - k/\Theta \big| / (k/\Theta) \le 0.10 \).  
- Monotone: larger Θ ⇒ smaller \( f_c \).  
- Re‑centering: ±1 sample shift yields same decision within the 5% bracket.

## Manifest fields

```jsonc
{
  "vision": {
    "steady_test": "dc_fraction",
    "epsilon_rho": 0.XX,
    "k_cycles_per_series": 1024,
    "Theta_values": [8,16,32],
    "f_pred": { "8": 128, "16": 64, "32": 32 },
    "f_c_emp": { "8": 127, "16": 64, "32": 32 },
    "recenter_ok": true
  }
}
```
